import numpy as np
from mpl_toolkits.mplot3d.art3d import Poly3DCollection, Line3DCollection
import mpl_toolkits.mplot3d.art3d as art3d
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle
from scipy.spatial.transform import Rotation
plt.rcParams['font.family'] = 'IPAmjMincho'

def descartes_3d(ax, ran_x, ran_y, ran_z, ax_title, 
                 x_label = "x軸", y_label = "y軸", z_label="z軸"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_zlabel(z_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_zlim(ran_z[0], ran_z[1])
    ax.set_title(ax_title, fontsize = 16)
    ax.grid()

def m_sphere(ax,r=1,
             start_z_arg=0,end_z_arg=2*np.pi,
             start_x_arg=0,end_x_arg=2*np.pi,
             color="blue",alpha=0.5):
    xx_arg = np.linspace(start_x_arg, end_x_arg, 100) 
    zz_arg = np.linspace(start_z_arg, end_z_arg, 100) 

    xx, zz = np.meshgrid(xx_arg, zz_arg) 
    x = np.cos(xx) * np.sin(zz) * r 
    y = np.sin(xx)*np.sin(zz) * r
    z = np.cos(zz) * r 

    ax.plot_surface(x,y,z, color='blue',alpha=0.5)

fig = plt.figure(figsize = (6, 6))
ax = fig.add_subplot(111, projection='3d')
title1 = "Tokyo University 2023 Math 第６問 球 NO2"

descartes_3d(ax, [-2, 2], [-2, 2], [-2, 2], title1)

m_sphere(ax,r=1)

plt.show()