import numpy as np
from mpl_toolkits.mplot3d.art3d import Poly3DCollection, Line3DCollection
import mpl_toolkits.mplot3d.art3d as art3d
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle
from scipy.spatial.transform import Rotation
plt.rcParams['font.family'] = 'IPAmjMincho'

def descartes_3d(ax, ran_x, ran_y, ran_z, ax_title, 
                 x_label = "x軸", y_label = "y軸", z_label="z軸"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_zlabel(z_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_zlim(ran_z[0], ran_z[1])
    ax.set_title(ax_title, fontsize = 16)
    ax.grid()


def m_cube(ax,apex1,facecolors="blue",edgecolors="red",alpha=0.5):
    ax.scatter3D(apex1[:, 0], apex1[:, 1], apex1[:, 2],color="red",s=6)
    cube1 = [[apex1[0],apex1[1],apex1[2],apex1[3]],
            [apex1[4],apex1[5],apex1[6],apex1[7]],
            [apex1[0],apex1[1],apex1[5],apex1[4]],
            [apex1[2],apex1[3],apex1[7],apex1[6]],
            [apex1[1],apex1[2],apex1[6],apex1[5]],
            [apex1[4],apex1[7],apex1[3],apex1[0]]]
    ax.add_collection3d(Poly3DCollection(cube1, facecolors = facecolors,
                        linewidths=0.3, edgecolors=edgecolors, alpha=alpha))

fig = plt.figure(figsize = (6, 6))
ax = fig.add_subplot(111, projection='3d')
title1 = "Tokyo University 2023 Math 第６問 立方体 NO1"

descartes_3d(ax, [-2, 2], [-2, 2], [-2, 2], title1)

apex1 = np.array([[-1, -1, -1],
                  [1, -1, -1 ],
                  [1, 1, -1],
                  [-1, 1, -1],
                  [-1, -1, 1],
                  [1, -1, 1 ],
                  [1, 1, 1],
                  [-1, 1, 1]])


m_cube(ax,apex1,facecolors="cyan",alpha=0.3)

plt.show()