import numpy as np
import sympy as sp
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　Σ 1/(n+k)"
x_label = "ｘ軸"
y_label = "ｙ軸"

descartes(ax, [0,80], [-1, 2],title1,x_label,y_label)
colorlist = ["r", "g", "b", "c", "m", "y", "w", "k"]

k=sp.var('k',integer=True)
s,ss=[],[]
for n in range(100):
    s = sp.summation(1/(n+k),(k,1,n))
    ss.append(float(s))

nn=np.arange(len(ss))
ax.scatter(nn,ss,color=colorlist[7],s=4)
ax.plot(nn,ss,color=colorlist[0])

bn=[np.log(2)]*len(ss)
ax.plot(nn,bn,color=colorlist[2])

ax.text(1,0.8,"log(2)={}".format(np.log(2)),color=colorlist[2])

plt.show()