import numpy as np
import sympy as sp
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　数列の極限　応用例題２"
x_label = "ｘ軸"
y_label = "ｙ軸"

descartes(ax, [0,60], [-3, 3],title1,x_label,y_label)
colorlist = ["r", "g", "b", "c", "m", "y", "w", "k"]
n=np.arange(1,1001)
i=0
for r in 1.1,1,0.9,-0.9,-1.1:
    an=r**n/(1+r**n)
    ax.scatter(n,an,color=colorlist[7],s=4)
    ax.plot(n,an,color=colorlist[i%8])
    ax.text(10.5,2.6-i/5,"r の値は {}".format(r),color=colorlist[i%8])
    i+=1
plt.show()