import numpy as np
import sympy as sp
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　数列の極限　練習７"
x_label = "ｘ軸"
y_label = "ｙ軸"

descartes(ax, [0,100], [-1, 1],title1,x_label,y_label)

x=sp.var('x',integer=True)
y=sp.sqrt(x**2+x)-x

lim_an = sp.limit(y, x, sp.oo)
n=np.arange(100)
an=np.sqrt(n**2+n)-n
ax.scatter(n,an,color='r',s=1)
ax.text(10,0.8,"sqrt(n**2+n)-n の極限値は{}".format(lim_an),color='b')
plt.show()