import sympy as sp
import japanize_matplotlib
colorlist = ["r", "g", "b", "c", "m", "y",  "k"]
x=sp.var('x',real=True)
f=sp.floor(x)
lim_right = sp.limit(f, x, 0,'+')
lim_left = sp.limit(f,x,0,'-')

p=sp.plot(f,(x,-5,-4),title='数学Ⅲ 関数の極限 練習６',show=False
          ,ylabel=('y 軸'),xlabel=('x 軸')
           ,xlim=(-6,6),ylim=(-6,6),detect_poles=True
           ,color=colorlist[0],legend=True)
for i in range(9):
    p2=sp.plot(f,(x,-4+i,-3+i),color=colorlist[i%7],show=False)
    p.append(p2[0])
for i in range(10):
    p[i].label='y=[x] {}<=x<={}'.format(-5+i,-4+i)
    if i==4:
        p[i].label='x→-0 における左側極限は{}'.format(lim_left)
    if i==5:
        p[i].label='x→+0 における右側極限は{}'.format(lim_right)
p.show()