import sympy as sp
import japanize_matplotlib

x=sp.var('x',real=True)
f=sp.sin(x)/x
g=sp.sin(3*x)/x
lim_f = sp.limit(f, x, 0)
lim_g = sp.limit(g, x, 0)

p=sp.plot(f,g,(x,-10,10),title='数学Ⅲ 関数の極限 練習５',show=False
          ,ylabel=('y 軸'),xlabel=('x 軸')
           ,xlim=(-10,10),ylim=(-5,5),detect_poles=True
           ,legend=True)
p[0].label='y=sinx/x の x→0 における極限は{}'.format(lim_f)
p[0].line_color='b'
p[1].label='y=sin3x/x の x→0 における極限は{}'.format(lim_g)
p[1].line_color='r'
p.show()
