import sympy as sp
import japanize_matplotlib

x=sp.var('x',real=True)
f=sp.sin(1/x)
g=sp.cos(1/x)
lim_f = sp.limit(f, x, sp.oo)
lim_g = sp.limit(g, x, sp.oo)

p=sp.plot(f,g,(x,-5,5),title='数学Ⅲ 関数の極限 練習４',show=False
          ,ylabel=('y 軸'),xlabel=('x 軸')
           ,xlim=(-5,5),ylim=(-5,5),detect_poles=True
           ,legend=True)
p[0].label='y=sin(1/x)の x→oo における極限は{}'.format(lim_f)
p[0].line_color='b'
p[1].label='y=cos(1/x)の x→oo における極限は{}'.format(lim_g)
p[1].line_color='r'
p.show()
