import numpy as np
import sympy as sp
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　関数の極限　練習１"
x_label = "x軸"
y_label = "y軸"

descartes(ax, [-5,5], [-5, 5],title1,x_label,y_label)

colorlist = ["r", "g", "b", "c", "m", "y",  "k"]


flag1=False
for xx in range(-500,500):
    try:
        x=xx/100
        y=(x**2+3*x+2)/(x+1)
        ax.scatter(x,y,color=colorlist[2],s=0.1)
    except ZeroDivisionError as e:
        flag1=True
        y=x+2
        sx,sy=x,y
        ax.scatter(x,y,color=colorlist[0],s=20)
        continue
       
if flag1 == True:
    ax.text(sx+0.2,sy-0.2,"P({} , {})".format(sx,sy))

plt.show()