import numpy as np
import sympy as sp
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　関数　練習２"
x_label = "x軸"
y_label = "y軸"

descartes(ax, [-5,5], [-5, 5],title1,x_label,y_label)

colorlist = ["r", "g", "b", "c", "m", "y",  "k"]

x,y=sp.var('x y',real=True)

f = y-2/(x-1)
g =y-x

s = sp.solve([f, g], [x,y])

xx=sp.StrictGreaterThan(2/(x-1),x)

x1=np.linspace(-5,5,100)
y1=2/(x1-1)
ax.plot(x1,y1,color=colorlist[0])
x2=np.linspace(-5,5,100)
y2=x2
ax.plot(x2,y2,color=colorlist[1])
ax.text(s[0][0]+0.2,s[0][1]-0.2,"P({},{})".format(s[0][0],s[0][1]))
ax.text(s[1][0]+0.2,s[1][1]-0.2,"P({},{})".format(s[1][0],s[1][1]))
ax.text(-4.8,4,"不等式{}".format(xx))
ax.text(-4.8,3.5,"解{}".format(sp.solve(xx)))
plt.show()