import numpy as np
from sympy import *
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　式と曲線　COLUMN [2]"
x_label = "x軸"
y_label = "y軸"

def m_pola(r,theta):
    return r*np.cos(theta),r*np.sin(theta)

descartes(ax, [-2,2], [-2, 2],title1,x_label,y_label)

colorlist = ["r", "g", "b", "c", "m", "y",  "k"]
i=0
for t in np.linspace(0,np.pi,100):
    ax.plot([np.cos(t),np.cos(3*t)],[np.sin(t),np.sin(3*t)],color=colorlist[i%7])
    i+=1

plt.show()