import numpy as np
from sympy import *
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　式と曲線　練習７"
x_label = "x軸"
y_label = "y軸"

descartes(ax, [-5,5], [-5,5],title1,x_label,y_label)

def m_pola(r,theta):
    return r*np.cos(theta),r*np.sin(theta)

t=np.linspace(0,np.pi*2,1000)

colorlist = ["r", "g", "b", "c", "m", "y", "w", "k"]
i=0

for e in 1/3,1,3:

    r=2*e/(1+e*np.cos(t))
    x,y=m_pola(r,t)
    ax.plot(x,y,color=colorlist[i%8])
    i += 1

plt.show()