import numpy as np
from sympy import *
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　式と曲線　練習６"
x_label = "ｘ軸"
y_label = "ｙ軸"

descartes(ax, [-10,10], [-10, 10],title1,x_label,y_label)

t=np.linspace(0,np.pi*6,1000)
colorlist = ["r", "g", "b", "c", "m", "y", "w", "k"]
i=0
for [a,b] in [1,3],[3,1] ,[3,3]:
    tt=(1+a/b)*t
    x=(a+b)*np.cos(t)-b*np.cos(tt)
    y=(a+b)*np.sin(t)-b*np.sin(tt)
    ax.plot(x,y,color=colorlist[i%8])
    i += 1
plt.show()