import numpy as np
from sympy import *
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　式と曲線　練習４"
x_label = "x 軸"
y_label = "y 軸"

descartes(ax, [-5,40], [-15, 15],title1,x_label,y_label)

t=np.linspace(0,np.pi*6,1000)
x=2*t-3*np.sin(t)
y=2-3*np.cos(t)

ax.plot(x,y,color="blue")

plt.show()