import numpy as np
from sympy import *
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　式と曲線　練習３"
x_label = "x 軸"
y_label = "y 軸"

descartes(ax, [-5,5], [-5, 5],title1,x_label,y_label)

theta=np.linspace(0,np.pi*2,1000)
y=3/np.cos(theta)
x=2*np.tan(theta)
ax.plot(x,y,color="blue")

plt.show()