import numpy as np
from sympy import *
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　複素数平面　練習８"
x_label = "実軸"
y_label = "虚軸"

descartes(ax, [-5,5], [-5, 5],title1,x_label,y_label)

def m_line(z1,z2):
    alpha=np.angle(z2-z1)+np.pi/2
    r=np.linspace(-10,10,100)
    return r*(np.cos(alpha)+1j*np.sin(alpha))+(z1+z2)/2

z1=1j
ax.plot(np.real(z1),np.imag(z1),marker=".",markersize=10,color="red")
ax.text(np.real(z1)+0.1,np.imag(z1),"{}".format(z1))
z2=np.sqrt(3)-1j
ax.plot(np.real(z2),np.imag(z2),marker=".",markersize=10,color="red")
ax.text(np.real(z2)+0.1,np.imag(z2),"sqrt(3)-1j")
z=m_line(z1,z2)
ax.plot(np.real(z) ,np.imag(z) , color = "blue")
ax.text(-4,-1.4,"|z-1j|=|z-sqrt(3)+1j")


plt.show()