import numpy as np
from sympy import *
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　複素数平面　練習７"
x_label = "実軸"
y_label = "虚軸"

descartes(ax, [-5,5], [-5, 5],title1,x_label,y_label)

def m_circle(r,cp):
    t=np.linspace(0,2*np.pi,1000)
    return r*(np.cos(t)+1j*np.sin(t))+cp

r=2
cp=0
z=m_circle(r,cp)
ax.plot(np.real(z) ,np.imag(z) , color = "blue")
ax.text(-4,-3,"(1) |z|=2 青")

r=1
cp=1j
z=m_circle(r,cp)
ax.plot(np.real(z) ,np.imag(z) , color = "green")
ax.text(-4,-3.5,"(2) |z-i|=1 緑")

r=2
cp=1+1j
z=m_circle(r,cp)
ax.plot(np.real(z) ,np.imag(z) , color = "red")
ax.text(-4,-4,"(3) |z--1-i|=2 赤")

plt.show()