import numpy as np
from sympy import *
import matplotlib.pyplot as plt
from IPython.display import display
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　複素数平面　練習６"
x_label = "実軸"
y_label = "虚軸"
descartes(ax, [-15,15], [-15, 15],title1,x_label,y_label)

def m_div_point(mn,alpha,beta):
    ganma=(alpha*mn[1]+beta*mn[0])/sum(mn)
    return ganma

alpha,beta,ganma,z = symbols('alpha beta ganma z',complex=True)
alpha=3-I
beta=-2*(1-2*I)
for z in alpha,beta:
    ax.scatter(re(z) ,im(z) , color = "blue")
    ax.text(re(z)+0.8,im(z)-0.2,"{}".format(z))

mn=[3,2]
ganma=m_div_point(mn,alpha,beta)
title1='内分点'
z=ganma
ax.scatter(re(z) ,im(z) , color = "green")
ax.text(re(z)+0.8,im(z)-0.2,"{}:{}".format(title1,z))

mn=[3,-2]
ganma=m_div_point(mn,alpha,beta)
title1='外分点'
z=ganma
ax.scatter(re(z) ,im(z) , color = "red")
ax.text(re(z)+0.8,im(z)-0.2,"{}:{}".format(title1,z))

plt.show()