import numpy as np
from sympy import *
import cmath
import matplotlib.pyplot as plt
import japanize_matplotlib

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")

fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　複素数平面　練習３"
x_label = "実軸"
y_label = "虚軸"
descartes(ax, [-3,3], [-3, 3],title1,x_label,y_label)

z=Symbol("z",complex=True)
theta=Symbol("theta",real=True)

def m_irot(z=0,theta=0):
    return z*(cos(theta)+sin(theta)*I)

z1,z2,z3=symbols("z1:4",complex=True)
theta1,theta2,theta3=symbols("theta1:4",real=True)

z1=1
theta1=pi/5
z2=2*I
theta2=pi/7
z3=1+I
theta3=pi/9

for i in range(10):
    z=m_irot(z1,theta1*i)
    ax.scatter(re(z) ,im(z) , color = "blue")
    ax.text(re(z)+0.1,im(z),"Z{}:".format(i+1))

    z=m_irot(z2,theta2*i)
    ax.scatter(re(z) ,im(z) , color = "green")
    ax.text(re(z)+0.1,im(z),"Z{}:".format(i+1))

    z=m_irot(z3,theta3*i)
    ax.scatter(re(z) ,im(z) , color = "red")
    ax.text(re(z)+0.1,im(z),"Z{}:".format(i+1))

ax.scatter(-2.2 ,-2.3 , color = "blue")
ax.scatter(-2.2 ,-2.5 , color = "green")
ax.scatter(-2.2 ,-2.7 , color = "red")
ax.text(-2,-2.4,"回転角 θ={}  複素数 z={}".format(theta1,z1))
ax.text(-2,-2.6,"回転角 θ={}  複素数 z={}".format(theta2,z2))
ax.text(-2,-2.8,"回転角 θ={}  複素数 z={}".format(theta3,z3))

plt.show()