import numpy as np
from sympy import *
import matplotlib.pyplot as plt
import japanize_matplotlib
#plt.rcParams['font.family'] = 'IPAmjMincho'

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　複素数平面　NO1"
x_label = "実軸"
y_label = "虚軸"
descartes(ax, [-10,10], [-10, 10],title1,x_label,y_label)
z1,z2,z3,z4=symbols("z1:5",complex=True)
z1=-1+2*I
z2=3-2*I
z3=2
z4=-I
i=0
#z=[0,-1+2j,3-2j,2,-1j]
for z in z1,z2,z3,z4:
    i += 1
    ax.scatter(re(z) ,im(z) , color = "blue")
    ax.text(re(z)+0.4,im(z),"Z{}: {}".format(i,z))

t=z1*z2
conj_t=t.conjugate()

ax.scatter(re(conj_t) ,im(conj_t) , color = "red")
ax.text(re(conj_t)+0.4,im(conj_t),"T{}".format(conj_t))

pq=Abs(z2-z1)
ax.text(-8,-9,"PQ={}".format(pq))

plt.show()