import numpy as np
import cmath
import matplotlib.pyplot as plt
plt.rcParams['font.family'] = 'IPAmjMincho'

def descartes(ax, ran_x, ran_y, ax_title,x_label = "x", y_label = "y"):
    ax.set_xlabel(x_label, fontsize = 12)
    ax.set_ylabel(y_label, fontsize = 12)
    ax.set_xlim(ran_x[0], ran_x[1])
    ax.set_ylim(ran_y[0], ran_y[1])
    ax.set_title(ax_title, fontsize = 14)
    ax.grid()
    ax.axhline(0, color = "black")
    ax.axvline(0, color = "black")


fig = plt.figure(figsize = (5, 5))
ax = fig.add_subplot(111)


title1 = "数学Ⅲ　複素数平面　NO1"
x_label = "実軸"
y_label = "虚軸"
descartes(ax, [-10,10], [-10, 10],title1,x_label,y_label)


z=[0,-1+2j,3-2j,2,-1j]
for i in range(1,5):
    ax.scatter(np.real(z[i]) ,np.imag(z[i]) , color = "blue")
    ax.text(np.real(z[i])+0.2,np.imag(z[i]),"Z{}:{}".format(i,z[i]))

t=z[1]*z[2]
conj_t=t.conjugate()

ax.scatter(np.real(conj_t) ,np.imag(conj_t) , color = "red")
ax.text(np.real(conj_t)+0.2,np.imag(conj_t),"T{}".format(conj_t))

pq=np.abs(z[2]-z[1])
ax.text(-8,-9,"PQ={}".format(pq))

plt.show()
