import numpy as np 
import IPython

def play_all(freq):
    rate = 48000
    duration = 0.5
    x = np.zeros(int(rate * duration * 8))
    for i in range(8):
        t = np.linspace(0., duration, int(rate * duration))
        start = int(rate * duration * i)
        end = int(rate * duration * (i + 1))
        x[start:end] = np.sin(2.0 * np.pi * freq[i] * t)
    return IPython.display.Audio(x, rate=rate, autoplay=True)

while True:
    try:
        flag1 = int(input("flag (1：等差数列　2：３倍音　3:等比数列) = "))
        if flag1 > 3:
            print("入力値は３以下の整数です。")
            continue
        if flag1 < 1:
            print("入力値は１以上の整数です。")
            continue
        break
    except ValueError:
        pass
        break

scale1,scale2,scale3=[],[],[]
rate1,rate2=[],[]
dif1,dif2=[],[]
index1=[0,2,4,5,7,9,11,12]

wavelength=1
for i in range(13):
    scale1.append((24-i)/24)
    scale3.append((1/2)**(i/12))
    wavelength=wavelength/3
    while wavelength < 1/2:
        wavelength = wavelength *2
    scale2.append(wavelength)
scale2.append(0.5)
del scale2[12]

scale1=sorted(scale1,reverse=True)
scale2=sorted(scale2,reverse=True)
scale3=sorted(scale3,reverse=True)

ratio1 = [1] * 8
ratio2 = [1] * 8
ratio3 = [1] * 8

for i in range(8):
    ratio1[i]=1/scale1[index1[i]]
    ratio2[i]=1/scale2[index1[i]]
    ratio3[i]=1/scale3[index1[i]]

freq=[1] * 8
freq[1] = [440.0  * ratio1[i] for i in range(8)]
freq[2] = [440.0  * ratio2[i] for i in range(8)]
freq[3] = [440.0  * ratio3[i] for i in range(8)]

play_all(freq[flag1])